unit Unit1;
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, FileCtrl, ComCtrls, ExtCtrls, CheckLst;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    DriveComboBox1: TDriveComboBox;
    Button1: TButton;
    StaticText1: TStaticText;
    edDocCount: TEdit;
    Label1: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    cbb1: TComboBox;
    lbl1: TLabel;
    lbl2: TLabel;
    pnl1: TPanel;
    lbl3: TLabel;
    lbl4: TLabel;
    chk1: TCheckBox;
    chk2: TCheckBox;
    chk3: TCheckBox;
    chk4: TCheckBox;
    chk5: TCheckBox;
    chk6: TCheckBox;
    chk7: TCheckBox;
    stat1: TStatusBar;
    procedure StringGrid1DblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);

  private
    { Private declarations }
    function FAttrDialog() : word;
  public
    { Public declarations }
    procedure ShowDir(RqDirFiles : string);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// -------------------------------------------------------------------------
const AllFAttr  = $FF;         //     
                               //     
// -------------------------------------------------------------------------
var CurDir     : string;       //  
    StrList    : TStringList;  //   

// ===========================================================================
//        
// ===========================================================================
//      
function FAttrToStr (RqAttr : word; RqName : string) : string;
var WStr : string;
begin
  WStr := '';
  if (RqAttr and faSymLink)   > 0 then WStr := '[LNK] ';
  if (RqAttr and faDirectory) > 0
  then begin
     if RqName = '.'  then WStr := WStr + '';
     if RqName = '..' then WStr := WStr + '';
     if (RqName <> '.') and (RqName <> '..')
     then WStr := WStr + '[DIR] ';
  end;
  if (RqAttr and faVolumeID)  > 0 then WStr := WStr + '[VID] ';
  if (RqAttr and faSysFile)   > 0 then WStr := WStr + 'S';
  if (RqAttr and faHidden)    > 0 then WStr := WStr + 'H';
  if (RqAttr and faReadOnly)  > 0 then WStr := WStr + 'R';
  if (RqAttr and faArchive)   > 0 then WStr := WStr + 'A';
  if WStr = '' then WStr := '?';
  Result := WStr;
end;
// ---------------------------------------------------------------------------
//       
function ReShowDir(RqDir    : string;    //  
                   RqFAttr  : word;      //  
                   RqExt    : string;    //   '.Ext'
               var DocCount : cardinal;  //     
                   RqList   : TStrings)  : Cardinal;
var
  WDir   : string;
  sr     : TSearchRec;
  WExt   : string;
  WStr   : string;
begin
    WExt   := UpperCase(RqExt);
    WDir   := RqDir + '\*.*';
    Result := 0;
    if FindFirst(WDir, RqFAttr, sr) = 0 then
    begin
      repeat
        if (sr.Name <> '')
        then begin
          if (sr.Name <> '.') and (sr.Name <> '..')
          then begin
             if ((sr.Attr and faDirectory) > 0)
             then begin
                //  
                WDir := RqDir + '\' + sr.Name;
                ReShowDir(WDir, RqFAttr, RqExt, DocCount, RqList);
             end
             else begin
                //      
                WStr := UpperCase(ExtractFileExt(sr.Name));
                if (WStr = WExt)
                then begin
                   Inc(DocCount);   //     
                   Inc(Result);     //     
                   if Assigned(RqList)
                   then RqList.AddObject(RqDir + '\' + sr.Name, pointer(sr.Attr))
                end;
             end;
          end;
      end;
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;
end;
// ---------------------------------------------------------------------------
//    
function TForm1.FAttrDialog() : word;
begin
  Result := 0;
  if chk1.Checked then Result := faReadOnly;
  if chk2.Checked then Result := Result or faHidden;
  if chk3.Checked then Result := Result or faSysFile;
  if chk4.Checked then Result := Result or faVolumeID;
  if chk5.Checked then Result := Result or faDirectory;
  if chk6.Checked then Result := Result or faArchive;
  if chk7.Checked then Result := Result or AllFAttr; // faAnyFile;
end;
// ---------------------------------------------------------------------------
//   
procedure TForm1.ShowDir(RqDirFiles : string);
const TitArr : array [0..4] of string =
( '',' ','','',' ');
var   FileAttrs  : word;         //     
      sr         : TSearchRec;
      Ind        : integer;
begin
  StringGrid1.RowCount := 1;
  FileAttrs := FAttrDialog();

  with StringGrid1 do
  begin
    RowCount := 1;
    //Ind := RowCount - 1;
    if FindFirst(RqDirFiles + '\*.*', FileAttrs, sr) = 0 then
    begin
      repeat
        sr.Attr := sr.Attr and $ff;
        if ((sr.Attr and FileAttrs) = sr.Attr) and (sr.Name <> '')
        then begin
          Ind := RowCount;
          RowCount := RowCount + 1;
          Cells[0,Ind] := IntToStr(Ind);
          Cells[1,Ind] := sr.Name;
          Cells[3,Ind] := IntToStr(sr.Size);
          Cells[4,Ind] := DateTimeToStr(FileDateToDateTime(sr.Time));

          if (sr.Attr and faDirectory) > 0
          then Objects [2, Ind] := Pointer($FFFF)
          else Objects [2, Ind] := nil;

          Cells[2,Ind] := FAttrToStr(sr.Attr, sr.Name);
        end;
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;
    if RowCount < 2
    then begin
       RowCount := 2;
       for Ind := 0 to ColCount - 1 do Cells[Ind, 1] := '';
    end;
    FixedRows := 1;
    for Ind := 0 to ColCount - 1 do Cells[Ind, 0] := TitArr[Ind];
  end; // of with StringGrid1
end;

// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
//       
procedure TForm1.CheckBoxClick(Sender: TObject);
begin
  CurDir := GetCurrentDir();
  StaticText1.Caption := CurDir;
  ShowDir(CurDir);
end;
// ---------------------------------------------------------------------------
//   
procedure TForm1.StringGrid1DblClick(Sender: TObject);
begin
  with StringGrid1 do
  begin
     if Objects [2, Row] <> nil
     then begin
        ChDir(Cells[1,Row]);
        CurDir := GetCurrentDir;
        StaticText1.Caption := CurDir;
        ShowDir(CurDir);
     end;
  end;
end;
// ---------------------------------------------------------------------------
//   
procedure TForm1.DriveComboBox1Change(Sender: TObject);
var Disk : char;
begin
  Disk := DriveComboBox1.Drive;
  SetCurrentDir (Disk + ':');
  SetCurrentDir (Disk + ':\');
  CurDir := Disk + ':\';
  StaticText1.Caption := CurDir;
  ShowDir(CurDir);
end;

// ===========================================================================
//      
// ===========================================================================
// ---------------------------------------------------------------------------
//      
procedure TForm1.Button1Click(Sender: TObject);
var WExt    : string;
    WCount  : cardinal;
begin
    CurDir := GetCurrentDir();
    StrList := nil;
    WCount := 0;
    WExt := UpperCase(Trim(cbb1.Text));
    if WExt[1] <> '.' then WExt := '.' + WExt;
    try
       Screen.Cursor := crHourGlass;
       stat1.Panels[0].Text := '    ' +
                               StaticText1.Caption +
                               '       *' + WExt;
       stat1.Repaint;
       ReShowDir(CurDir, AllFAttr, WExt, WCount, StrList);
    finally
       edDocCount.Text := IntToStr(WCount);
       if StrList <> nil then StrList.Free;
       StrList := nil;
    end;
    stat1.Panels[0].Text := ' ';
    Screen.Cursor := crDefault;
end;

// ---------------------------------------------------------------------------
//   
procedure TForm1.FormCreate(Sender: TObject);
begin
  CurDir := GetCurrentDir();
  ShowDir(CurDir);
end;

end.
